// Copyright 1994 by Jon Dart.                                  s
// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "arasan.h"
#include "resource.h"
#include "mainfrm.h"
#include "arasavw.h"
#include "globals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
        //{{AFX_MSG_MAP(CMainFrame)
                // NOTE - the ClassWizard will add and remove mapping macros here.
                //    DO NOT EDIT what you see in these blocks of generated code !
        ON_WM_CREATE()
        ON_WM_CLOSE()
                // Global help commands
        ON_COMMAND(ID_HELP_INDEX, CFrameWnd::OnHelpIndex)
        ON_COMMAND(ID_HELP_USING, CFrameWnd::OnHelpUsing)
        ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
        //ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
        //ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpIndex)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
        // same order as in the bitmap 'toolbar.bmp'
        ID_FILE_NEW,
        ID_FILE_OPEN,
        ID_FILE_SAVE,
                ID_SEPARATOR,
        ID_EDIT_CUT,
        ID_EDIT_COPY,
        ID_EDIT_PASTE,  
/** LATER        
                ID_SEPARATOR,
        ID_FILE_PRINT,
**/        
                        ID_SEPARATOR,
        ID_BROWSE_PREVIOUSGAME,
        ID_TAKEBACK,
        ID_FORWARD,
        ID_BROWSE_NEXTGAME,
                        ID_SEPARATOR,
        ID_APP_ABOUT,
};

static UINT BASED_CODE indicators[] =
{
        ID_SEPARATOR,           // status line indicator
        ID_INDICATOR_NUM,
        ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
        // TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

void CMainFrame::set_status(UINT id, LPCTSTR str, BOOL bUpdate)
{
    m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(id),
    str,bUpdate);
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT &cs)
{
    // Have to call the base version first because it sets the window
    // class.
    CFrameWnd::PreCreateWindow(cs);
    // Set the window size and position to where it was when we
    // last ran, or to some default otherwise.
    int x, y, w, h;
    global_options->get_app_geometry(&x,&y,&w,&h);
    cs.cx = w;
    cs.cy = h;
    cs.x = x;
    cs.y = y;
    return TRUE;
}

void CMainFrame::OnClose()
{
     // save the window size and position for the next time we are run.
    CRect rect;
    GetWindowRect(&rect);
    global_options->set_app_geometry(rect.left,rect.top,rect.Width(),rect.Height());
    CFrameWnd::OnClose();
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
        return -1;

#ifndef CBRS_TOOLTIPS
     if (!m_wndToolBar.Create(this) ||
#else
    if (!m_wndToolBar.Create(this,WS_CHILD | WS_VISIBLE | CBRS_TOP | CBRS_TOOLTIPS) ||
#endif    
        !m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
        !m_wndToolBar.SetButtons(buttons,
                                 sizeof(buttons)/sizeof(UINT)))
    {
        TRACE("Failed to create toolbar\n");
        return -1;      // fail to create
    }

    if (!m_wndStatusBar.Create(this) ||
        !m_wndStatusBar.SetIndicators(indicators,
                                      sizeof(indicators)/sizeof(UINT)))
    {
       TRACE("Failed to create status bar\n");
       return -1;      // fail to create
    }
   
    return 0;
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam)
{
    // forward this to the view class
    CArasanView *view = (CArasanView*)GetActiveView();
    if (view && view->IsKindOf(RUNTIME_CLASS(CArasanView)) )
        if (view->OnCommand(wParam, lParam))
            return TRUE;
    return CFrameWnd::OnCommand(wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
        CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
        CFrameWnd::Dump(dc);
}                                

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
